/******************************************************************************
*  Do not modify this file!
*  This file is auto-generated.
*  Any changes will be lost.
*  This interface is defined in model.xml
*
*  Filename: JCFMeetingMgrController.h
*
*  Generated on 
*
*  Copyright  Cisco Systems, Inc., All rights reserved.
*  170 West Tasman Drive, San Jose, California, 95134, USA
*
*  CONFIDENTIAL AND PROPRIETARY INFORMATION - DO NOT DISCLOSE
*
******************************************************************************/

#import "JCFUnifiedBusinessObject.h"

@protocol JCFMeetingCallbackDelegate;
#import "JCFMailServiceType.h"

struct MeetingMgrControllerOpaque;

#ifdef __cplusplus
#include <memory>
namespace CSFUnified
{
	class MeetingMgrController;
}
typedef std::shared_ptr<CSFUnified::MeetingMgrController> MeetingMgrControllerPtr;
#endif

#pragma mark Notifications
extern NSString *const JCFMeetingMgrControllerOnlineSwitchDidChangeNotification;
extern NSString *const JCFMeetingMgrControllerOfflineSwitchDidChangeNotification;


@interface JCFMeetingMgrController : JCFUnifiedBusinessObject
{
	@private
	struct MeetingMgrControllerOpaque *mMeetingMgrControllerCpp;


	id mOnlineSwitch;
	id mOfflineSwitch;
}

#pragma mark Properties

    #pragma mark Meetings
        
    @property (readonly, nonatomic, assign) BOOL onlineSwitch;
    @property (readonly, nonatomic, assign) BOOL offlineSwitch;


#pragma mark Methods

-(void) registerMeetingCallback:(id<JCFMeetingCallbackDelegate>)meetingCallback ;
-(void) unregisterMeetingCallback:(id<JCFMeetingCallbackDelegate>)meetingCallback ;
-(BOOL) isMeetingInProgress:(NSString*)meetingID;
-(void) getCMRInfo:(NSString*)meetingKeyList;
-(unsigned long) listMeetings:(int)year month:(int)month day:(int)day;
-(unsigned long) refreshMeetings;
-(BOOL) todayChanged:(BOOL)bForceChanged;
-(unsigned long) getMeetingDetail:(NSString*)meetingID;
-(unsigned long) viewMeetingById:(NSString*)meetingID;
-(BOOL) isInMeeting;
-(BOOL) canStartMeeting;
-(BOOL) canJoinMeeting;
-(unsigned long) launchMeetingById:(NSString*)meetingID;
-(BOOL) startInstantMeeting:(NSString*)meetingName vecInviteList:(NSArray*)vecInviteList;
-(BOOL) inviteToInstantMeeting:(NSString*)attendeeName;
-(BOOL) acceptInstantMeeting:(NSString*)sessioName;
-(BOOL) declineInstantMeeting:(NSString*)sessioName;
-(void) editInstantMeetingSetting;
-(unsigned long) sendEmail:(NSString*)tos subject:(NSString*)subject body:(NSString*)body meetingKey:(NSString*)meetingKey;
-(int) getInstantMeetingLastErrCode;
-(BOOL) startJoinMeetingByUrl:(NSString*)strURL;
-(NSString*) sendMeetingInvitation:(NSString*)attendees meetingID:(NSString*)meetingID msg:(NSString*)msg;
-(void) setMeetingReminderEnable:(BOOL)isEnable;
-(NSString*) sendMeetingReminder:(NSString*)attendees meetingID:(NSString*)meetingID msg:(NSString*)msg;
-(JCFMailServiceType) getCurrentMailType;
-(BOOL) openMeetingDetailPage:(NSString*)strURL;


#pragma mark Constructors

#ifdef __cplusplus

-(id) initWithMeetingMgrControllerPtr:(MeetingMgrControllerPtr)meetingMgrController;
-(id) initSuperWithMeetingMgrControllerPtr:(MeetingMgrControllerPtr)meetingMgrController;
//used by Forge - dangerous to call directly
-(id) initWithPtr:(UnifiedBusinessObjectPtr) cppPtr;

-(MeetingMgrControllerPtr) getMeetingMgrControllerPtr;

#endif

@end